$(document).ready(function () {
    _.delay(function () {
        new App();
    }, 500);
});
var AppModel = Backbone.Model.extend({
    defaults: {
        state: "drag",
        currentPath: undefined,
        historyPaths: [],
        lastUndos: [],
        drawnPaths: [],
        startNewPath: true
    }
});
var App = Backbone.View.extend({
    template: _.template($('#template_main').html()),
    events: {
        'click a.undo': 'undo',
        'click a.redo': 'redo',
        'click a.plus': 'plusZoom',
        'click a.minus': 'minusZoom',
        'click .gen': 'startCorrection',
        'click .paint': 'setPaint',
        'click .goto_einleitung': 'startEinleitung',
        'click .goto_startSplash': 'startSplashScreen',
        'click .goto_uebungen': 'startUebungen',
        'click .goto_uebungen_force': 'startUebungen_forced',
        'click .goto_start': 'startSeite',
        'click .goto_intro': 'startIntro',
        'click .goto_alles': 'startAlles',
        'click .goto_hilfe': 'startHilfe',
        'click .goto_hinterpfote': 'startHinterpfote',
        'click .goto_vorderpfote': 'startVorderpfote',
        'click .goto_nachschlagen': 'startNachschlagen',
        'click .goto_leitbahn': 'startLeitbahn',
        'click .goto_punkte_wichtig': 'startPunkteWichtig',
        'change #lb-select': 'startSelectedLB',
        'change #lb-change': 'changedLeitbahn',
        'change #lb-select_nachschlagen': 'startSelectedLBNachschlagen',
        'click .close-modal': 'closeCurrentModal'
    },
    initialize: function () {
        _.bindAll(this, 'resizeWindow');
        var that = this;
        // Dom stuff
        $(window).on("resize", _.debounce(this.resizeWindow, 0));
        $('body').append(this.el);
        this.$el.html(this.template({
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: true,
                        class: 'goto_start'
                    }
                ]
            })
        }));
        $(".paint").hide();

        $('#myCanvas').on('mousewheel', {
            mousewheel: {
                debounce: {
                    leading: true,
                    trailing: false,
                    preventDefault: true,
                    delay: 20
                }
            }
        }, function (e) {
            that.mouseWheel(e);
        });

        this.wichtige_punkte = {
            "3E": ["3E23", "3E5", "3E1"],
            "Bl": ["Bl67", "Bl60", "Bl40", "Bl28", "Bl23", "Bl20", "Bl17", "Bl14", "Bl12", "Bl11", "Bl10", "Bl1"],
            "Di": ["Di20", "Di16", "Di15", "Di11", "Di4", "Di1"],
            "Due": ["Dü18", "Dü6", "Dü3", "Dü1"],
            "Gb": ["Gb44", "Gb41", "Gb39", "Gb34", "Gb30", "Gb26", "Gb26 var", "Gb24", "Gb20", "Gb14", "Gb1"],
            "He": ["He9", "He7"],
            "KG": ["KG24", "KG17", "KG15", "KG8", "KG4", "KG1"],
            "Le": ["Le14", "Le13", "Le3"],
            "LG": ["LG26", "LG20", "LG16", "LG14", "LG4", "LG3", "LG1"],
            "Lu": ["Lu11", "Lu9", "Lu7", "Lu5", "Lu1"],
            "Ma": ["Ma45", "Ma44", "Ma40", "Ma36", "Ma30", "Ma25", "Ma12", "Ma3", "Ma1"],
            "MP": ["MP21", "MP10", "MP6", "MP4", "MP1"],
            "Ni": ["Ni27", "Ni6", "Ni3", "Ni1"],
            "PC": ["PC9", "PC6"]
        };

        this.leitbahnen = {
            "Ni": "Ni",
            "Bl": "Bl",
            "Lu": "Lu",
            "Di": "Di",
            "MP": "MP",
            "Ma": "Ma",
            "PC": "PC",
            "3E": "3E",
            "He": "He",
            "Due": "Dü",
            "Le": "Le",
            "Gb": "Gb",
            "LG": "LG",
            "KG": "KG"
        };

        this.leitbahn_color = {
            "3E": "#FDD5E5",
            "Bl": "#2E4E9D",
            "LG": "#D718B8",
            "Di": "#A29396",
            "Due": "#F06C23",
            "Gb": "#40AD41",
            "He": "#D50E35",
            "KG": "#822269",
            "Le": "#117C35",
            "Lu": "#F6F8F5",
            "Ma": "#F5DC32",
            "MP": "#F4B42B",
            "Ni": "#0B0303",
            "PC": "#CD1B5C"
        };

        this.paper = paper.setup('myCanvas');
        this.startNewPath = true;
        this.historyPaths = [];
        this.lastUndos = [];
        this.drawnPaths = [];
        this.bg = new paper.Raster('bg_img');
        _.delay(function () {
            that.paper.view.viewSize = new paper.Size($(window).width(), $(window).height());
            that.paper.view.draw();

            var bgbounds = that.bg.bounds,
                bounds = that.paper.view.bounds;
            var xScale = bounds.width / bgbounds.width,
                yScale = (bounds.height - 150) / bgbounds.height;

            if (xScale < yScale) {
                that.bg.scale(xScale);
            } else {
                that.bg.scale(yScale);
            }

            that.centerRaster();
            that.paper.view.play();
        }, 200);
        this.dragTool = new paper.Tool();
        this.triangleDrag = false;
        this.dragTool.onMouseDown = function (e) {
            that.mouseDownPoint = e.point;
            $("body").addClass('dragging');
            if (that.uebungMode == "punkte") {
                // check if there is a triangle near
                var triangle = that.paper.project.getItem({
                    className: function (c) {
                        return (c == 'Path' || c == 'PointText');
                    },
                    bounds: function (bounds) {
                        var x = false,
                            y = false;
                        if (bounds.x - 5 < e.point.x && bounds.x + bounds.width + 5 > e.point.x) {
                            x = true;
                        }
                        if (bounds.y - 3 < e.point.y && bounds.y + bounds.height + 3 > e.point.y) {
                            y = true;
                        }
                        if (x && y) {
                            return true;
                        }

                        return false;
                    }
                });

                if (triangle !== null) {
                    that.triangleDrag = triangle;

                    if (that.triangleDrag.className == "PointText") {
                        that.triangleDrag = that.triangleDrag.data.triangle;
                    }
                }
            }
        };
        this.dragTool.onMouseDrag = function (e) {
            if (that.triangleDrag !== false) {
                var prevX = that.triangleDrag.bounds.x,
                    prevY = that.triangleDrag.bounds.y;
                that.triangleDrag.bounds.setCenter(e.point);
                var newX = that.triangleDrag.bounds.x,
                    newY = that.triangleDrag.bounds.y;
                that.triangleDrag.data.text.translate(new paper.Point(newX - prevX, newY - prevY));
            } else {
                var newPoint = new paper.Point(that.mouseDownPoint.x - e.point.x, that.mouseDownPoint.y - e.point.y);
                var bounds = that.paper.view.bounds;
                that.paper.view.scrollBy(newPoint);
                that.paper.view.play();
            }
        };
        this.dragTool.onMouseUp = function (e) {
            $("body").removeClass("dragging");
            if (that.triangleDrag !== false) {
                that.triangleDrag = false;
            }
        };

        this.pathTool = new paper.Tool();
        this.pathTool.onMouseDown = function (e) {
            if (that.startNewPath) {
                var color = "blue";
                if (that.selectedLeitbahn !== undefined) {
                    color = that.leitbahn_color[that.selectedLeitbahn];
                }
                that.currentPath = new paper.Path({
                    segments: [],
                    strokeColor: color,
                    strokeWidth: 2,
                    fullySelected: false
                });
                that.drawnPaths.push(that.currentPath);
                that.startNewPath = false;
            }
            that.historyPaths.push([]);
            that.currentPath.bringToFront();
        };
        this.pathTool.onMouseUp = function (e) {
            var addedSeg = that.currentPath.add(e.point);
            that.addToHistory(addedSeg, that.currentPath.id);

            // always start new path (better user experience ??)
            that.startNewPath = true;
        };
        this.pathTool.onMouseDrag = function (e) {
            var addedSeg = that.currentPath.add(e.point);
            that.addToHistory(addedSeg, that.currentPath.id);
        };

        this.render();
    },
    render: function () {
        var that = this;
        this.startSplashScreen();
        this.hideKorrekturButton();
    },
    startSplashScreen: function () {
        this.closeCurrentModal();
        var tpl = _.template($('#template_splash').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Willkommensseite',
                        active: true,
                        class: 'goto_startSplash'
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-splash');
        this.delegateEvents();
    },
    startVideos: function () {
        $("video").mediaelementplayer({
            features: ['playpause', 'progress', 'fullscreen']
        });
    },
    setBreadcrumbs: function (bread_obj) {
        $(".toolbar-wrap", this.$el).prev().remove();
        var bread_html = _.template($("#bread").html(), {
            breads: bread_obj,
            main: true
        });
        $(".toolbar-wrap", this.$el).before(bread_html);
    },
    closeCurrentModal: function () {
        if (!_.isUndefined(this.$currentModal)) {
            this.$currentModal.remove();
        }
    },
    changedLeitbahn: function (e) {
        $(".leitbahn-change-wrap").prev().remove();
        $(".leitbahn-change-wrap").remove();
        var leitbahn = $(e.currentTarget).val();
        if (leitbahn !== "") {
            this.selectedLeitbahn = leitbahn;
            this.resetPaths();
            if (this.uebungMode == "punkte") {
                this.startPunkteWichtig();
            } else if (this.uebungMode == "leitbahn") {
                this.startLeitbahn();
            } else if (this.uebungMode == "nachschlagen") {
                this.startNachschlagenLeitbahn();
            }
        }
    },
    startSeite: function () {
        this.closeCurrentModal();
        var tpl = _.template($('#template_start').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: true,
                        class: 'goto_start'
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-start');
        this.delegateEvents();
    },
    startHilfe: function () {
        this.closeCurrentModal();
        var tpl = _.template($('#template_hilfe').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: false,
                        class: 'goto_start'
                    },
                    {
                        name: 'Hilfe',
                        active: true,
                        class: ''
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-hilfe');
        this.delegateEvents();
        this.startVideos();
        $(".eak_accordion").eak_accordion();
    },
    resetPaths: function () {
        _.each(this.drawnPaths, function (path) {
            path.remove();
        });
        this.historyPaths = [];
        this.lastUndos = [];
        this.drawnPaths = [];
        this.setBackgroundImage("leer");
        this.dragTool.activate();
        this.isPainting = false;
        $("body").removeClass("painting");
        $(".paint").removeClass("active").hide();
        $(".wichtige_punkte_wrap").remove();
        $(".leitbahn-change-wrap").prev().remove();
        $(".leitbahn-change-wrap").remove();
        this.showKorrekturButton();
    },
    hideKorrekturButton: function () {
        $(".gen").hide();
        $(".gen").parent().prev().hide();
    },
    showKorrekturButton: function () {
        $(".gen").show();
        $(".gen").parent().prev().show();
    },
    startPunkteAlle: function () {
        this.resetPaths();
        this.uebungMode = "alles";
        this.closeCurrentModal();
        this.showKorrekturButton();
    },
    startPunkteWichtig: function () {
        var that = this;
        this.resetPaths();
        this.uebungMode = "punkte";
        this.closeCurrentModal();
        var html = _.template($('#wichtige_punkte').html(), {
            leitbahn: this.selectedLeitbahn,
            wichtige_punkte: this.wichtige_punkte[this.selectedLeitbahn]
        });
        $('body').append(html);
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: 'goto_start'
            },
            {
                name: 'Übungen',
                active: false,
                class: 'goto_uebungen'
            },
            {
                name: 'Leitbahn: ' + this.selectedLeitbahn,
                active: false,
                class: 'goto_uebungen_force'
            },
            {
                name: "Punkte einzeichnen",
                active: false,
                class: "goto_punkte"
            }
        ];
        this.setBreadcrumbs(bread_obj);
        this.showKorrekturButton();
        this.setDraggable();
        this.addLeitbahnDropdown();
    },
    startVorderpfote: function () {
        this.selectedLeitbahn = undefined;
        var that = this;
        this.resetPaths();
        this.uebungMode = "vorderpfote";
        this.closeCurrentModal();
        var html = _.template($('#punkte_vorderpfote').html(), {
        });
        $('body').append(html);
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: 'goto_start'
            },
            {
                name: 'Übungen',
                active: false,
                class: 'goto_uebungen'
            },
            {
                name: 'Vorderpfote',
                active: true,
                class: 'goto_uebungen_force'
            }
        ];
        this.setBreadcrumbs(bread_obj);
        this.showKorrekturButton();
        this.setDraggable();
        this.setBackgroundImage('vorderpfote_leer');
    },
    startHinterpfote: function () {
        this.selectedLeitbahn = undefined;
        var that = this;
        this.resetPaths();
        this.uebungMode = "hinterpfote";
        this.closeCurrentModal();
        var html = _.template($('#punkte_hinterpfote').html(), {
        });
        $('body').append(html);
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: 'goto_start'
            },
            {
                name: 'Übungen',
                active: false,
                class: 'goto_uebungen'
            },
            {
                name: 'Hinterpfote',
                active: true,
                class: 'goto_uebungen_force'
            }
        ];
        this.setBreadcrumbs(bread_obj);
        this.showKorrekturButton();
        this.setDraggable();
        this.setBackgroundImage('hinterpfote_leer');
    },
    setDraggable: function () {
        var that = this;
        $(".wichtige_punkte > li").draggable({
            helper: function () {
                return $(this).find(".triangle");
            },
            cursorAt: {
                left: 7.5,
                top: 5.5
            },
            stop: function (e, ui) {
                var $li = ui.helper.parent();
                $li.fadeOut();
                that.createTriangle({
                    x: e.pageX,
                    y: e.pageY
                }, $(ui.helper).attr("data-leitbahn-name"), $(ui.helper).attr("data-color-name"));
                $("body").removeClass("dragging");
            },
            start: function () {
                $("body").addClass("dragging");
            }
        });
    },
    addLeitbahnDropdown: function () {
        $(".leitbahn-change-wrap").prev().remove();
        $(".leitbahn-change-wrap").remove();
        var html = _.template($("#leitbahn_dropdown").html(), {
            leitbahnen: {
                "He": this.leitbahnen.He
            },
            selected: this.selectedLeitbahn
        });
        $(".toolbar-main").append("<li class='sep'></li><li class='mt leitbahn-change-wrap'>" + html + "</li>");
    },
    createTriangle: function (position, name, colorname) {
        var that = this;
        this.paper.view.scrollBy(new paper.Point(0, 0));
        var offtop = $("#myCanvas").offset().top;
        var bounds = this.paper.view.bounds;
        var x = (position.x / this.paper.view.zoom) + bounds.x,
            y = ((position.y - 71) / this.paper.view.zoom) + 1 + bounds.y;
        var triangle = new paper.Path.RegularPolygon(new paper.Point(x, y), 3, 8);
        triangle.fillColor = this.leitbahn_color[colorname];
        var punktText = new paper.PointText(new paper.Point(x + 13, y + 2));
        punktText.content = name;
        punktText.justification = 'left';
        punktText.fillColor = this.leitbahn_color[colorname];
        punktText.fontWeight = "bold";
        punktText.fontSize = "12px";
        punktText.data.triangle = triangle;
        triangle.data.text = punktText;
        triangle.onMouseDown = function () {
            that.paper.tool = undefined;
        };
        triangle.onMouseDrag = function (e) {
            var prevX = this.bounds.x,
                prevY = this.bounds.y;
            this.bounds.setCenter(e.point);
            var newX = this.bounds.x,
                newY = this.bounds.y;
            this.data.text.translate(new paper.Point(newX - prevX, newY - prevY));
        };
        triangle.onMouseUp = function () {
            that.dragTool.activate();
        };
        this.drawnPaths.push(triangle);
        this.drawnPaths.push(punktText);
        this.historyPaths.push([]);
        this.addToHistory($.extend(true, {}, triangle.segments), triangle.id, true);
        this.paper.view.play();
    },
    startUebungen: function () {
        this.closeCurrentModal();
        var tpl = _.template($('#template_uebungen').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: false,
                        class: 'goto_start'
                    },
                    {
                        name: 'Übungen',
                        active: true,
                        class: ''
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-uebungen');
        this.delegateEvents();
    },
    startUebungen_forced: function () {
        this.closeCurrentModal();
        var tpl = _.template($('#template_uebungen').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: false,
                        class: 'goto_start'
                    },
                    {
                        name: 'Übungen',
                        active: true,
                        class: ''
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-uebungen');
        this.delegateEvents();
        // force select
        $('#lb-select').val(this.selectedLeitbahn);
        $('#lb-select').trigger('change');
    },
    startSelectedLB: function (e) {
        var leitbahn = $(e.currentTarget).val();
        this.selectedLeitbahn = leitbahn;
        this.closeCurrentModal();
        var tpl = _.template($('#template_uebungsart').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: false,
                        class: 'goto_start'
                    },
                    {
                        name: 'Übungen',
                        active: false,
                        class: 'goto_uebungen'
                    },
                    {
                        name: 'Leitbahn: ' + leitbahn,
                        active: true,
                        class: ''
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-uebungsart');
        this.delegateEvents();
    },
    startSelectedLBNachschlagen: function (e) {
        var leitbahn = $(e.currentTarget).val();
        if (leitbahn === "") {
            return;
        }
        this.selectedLeitbahn = leitbahn;

        this.startNachschlagenLeitbahn();
    },
    startNachschlagenLeitbahn: function () {
        this.resetPaths();
        this.uebungMode = "nachschlagen";
        this.closeCurrentModal();
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: 'goto_start'
            },
            {
                name: 'Leitbahnen und Punkte',
                active: false,
                class: 'goto_nachschlagen'
            },
            {
                name: 'Leitbahn: ' + this.selectedLeitbahn,
                active: true,
                class: ''
            }
        ];
        this.setBreadcrumbs(bread_obj);
        this.hideKorrekturButton();
        // set bg to all
        this.setBackgroundImage(this.selectedLeitbahn + "_alles");
        this.addLeitbahnDropdown();
    },
    startLeitbahn: function () {
        this.resetPaths();
        this.uebungMode = "leitbahn";
        this.closeCurrentModal();
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: 'goto_start'
            },
            {
                name: 'Übungen',
                active: false,
                class: 'goto_uebungen'
            },
            {
                name: 'Leitbahn: ' + this.selectedLeitbahn,
                active: false,
                class: 'goto_uebungen_force'
            },
            {
                name: 'Leitbahn einzeichnen',
                active: true,
                class: ''
            }
        ];
        this.setBreadcrumbs(bread_obj);
        // set background image for ueberpruefung
        this.setBackgroundImage('leer');
        $(".paint").show();
        this.showKorrekturButton();
        this.addLeitbahnDropdown();
    },
    startNachschlagen: function () {
        this.resetPaths();
        this.closeCurrentModal();
        var tpl = _.template($('#template_nachschlagen').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: false,
                        class: 'goto_start'
                    },
                    {
                        name: 'Leitbahnen und Punkte',
                        active: true,
                        class: ''
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-nachschlagen');
        this.delegateEvents();
    },
    startAlles: function () {
        this.resetPaths();
        this.closeCurrentModal();
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: 'goto_start'
            },
            {
                name: 'Leitbahnen und Punkte',
                active: false,
                class: 'goto_nachschlagen'
            },
            {
                name: 'Alle Leitbahnen und Punkte',
                active: true,
                class: ''
            }
        ];
        this.setBreadcrumbs(bread_obj);
        this.hideKorrekturButton();
        // set bg to all
        this.setBackgroundImage('alles');
    },
    startEinleitung: function () {
        this.closeCurrentModal();
        var tpl = _.template($('#template_einleitung').html(), {
            breadcrumbs: _.template($("#bread").html(), {
                breads: [
                    {
                        name: 'Start',
                        active: false,
                        class: 'goto_start'
                    },
                    {
                        name: 'Einleitung',
                        active: true,
                        class: ''
                    }
                ]
            })
        });
        this.$el.append(tpl);
        this.$currentModal = $('.step-einleitung');
        this.delegateEvents();
    },
    startIntro: function () {
        var that = this;
        this.closeCurrentModal();
        var bread_obj = [
            {
                name: 'Start',
                active: false,
                class: ''
            },
            {
                name: 'Einleitung',
                active: true,
                class: ''
            }
        ];
        this.setBreadcrumbs(bread_obj);

        this.uebungMode = "leitbahn";
        this.showKorrekturButton();
        $(".paint").show();
        var html = _.template($('#wichtige_punkte').html(), {
            leitbahn: "Ma",
            wichtige_punkte: this.wichtige_punkte.Ma
        });
        $('body').append(html);

        var intro = introJs().setOptions({
            nextLabel: "Weiter",
            prevLabel: "Zurück",
            doneLabel: "Tour beenden",
            skipLabel: "Überspringen",
            // showStepNumbers: false,
            showButtons: true,
            showBullets: false,
            exitOnOverlayClick: false,
            steps: [
                {
                    element: '.breadcrumbs',
                    intro: "<b>Navigation</b><br>Hier können Sie durch das Programm navigieren und sehen, wo Sie sich im Programm befinden.",
                    position: 'bottom'
                },
                {
                    element: '.toolbar-main',
                    intro: "<b>Werkzeugleiste</b><br>Hier befinden sich die Werkzeuge, die zum Zeichnen benötigt werden."
                },
                {
                    element: '.undo',
                    intro: "<b>Rückgängig</b><br>Mit diesem Button können Sie eine vorherige Aktion rückgängig machen (z.B. einen eingezeichneten Punkt wieder entfernen)."
                },
                {
                    element: '.redo',
                    intro: "<b>Wiederholen</b><br>Mit diesem Button können Sie eine vorherig rückgängig gemachte Aktion wiederholen."
                },
                {
                    element: '.plus',
                    intro: "<b>Heranzoomen</b><br>Mit diesem Button können Sie heranzoomen. Sie können ebenfalls mit dem Mausrad scrollen, um zu zoomen."
                },
                {
                    element: '.minus',
                    intro: "<b>Herauszoomen</b><br>Mit diesem Button können Sie herauszoomen. Sie können ebenfalls mit dem Mausrad scrollen, um zu zoomen."
                },
                {
                    element: '.paint',
                    intro: "<b>Zeichnen</b><br>Mit diesem Button können Sie die Leitbahn einzeichnen."
                },
                {
                    element: '.gen',
                    intro: "<b>Korrektur starten</b><br>Mit diesem Button wird die Korrektur gestartet. Es wird die richtige Leitbahn eingeblendet und kann somit mit der eingezeichneten Leitbahn verglichen werden"
                },
                {
                    element: '.goto_hilfe',
                    intro: "<b>Hilfe</b><br>Mit diesem Button gelangen Sie zum Hilfe-Fenster. Dort finden Sie häufig gestellte Fragen und Anleitungen, wie das Programm bedient wird.",
                    position: 'left'
                },
                {
                    element: '.wichtige_punkte_wrap',
                    intro: "<b>Punkte</b><br>Hier befinden sich die Punkte, die eingezeichnet werden müssen.",
                    position: 'left'
                },
                {
                    element: '.wichtige_punkte_wrap li[data-leitbahn-wrap="Ma30"]',
                    intro: "<b>Punkt ziehen</b><br>Um einen Punkt einzuzeichnen, müssen Sie ihn mit der Maus aus der Liste herausziehen. Klicken und halten Sie die Maustaste gedrückt, um einen Punkt zu ziehen.",
                    position: 'left'
                }
            ]
        }).start();

        intro.oncomplete(function () {
            that.startSeite();
            $(".wichtige_punkte_wrap").remove();
            $(".paint").hide();
        });

        intro.onexit(function () {
            that.startSeite();
            $(".wichtige_punkte_wrap").remove();
            $(".paint").hide();
        });
    },
    resizeWindow: function () {
        var that = this;
        var $w = $(window);
        that.paper.view.viewSize = new paper.Size($w.width(), $w.height());
        that.paper.view.draw();

        var view = that.paper.view,
            bounds = view.bounds,
            bgBounds = that.bg.bounds;

        // calculate the zoom to fit complete screen
        var xZoom = bounds.width / (bgBounds.width),
            yZoom = bounds.height / (bgBounds.height + 170),
            newZoom = view.zoom * xZoom;

        if (yZoom < xZoom) newZoom = view.zoom * yZoom;

        view.zoom = newZoom;
        this.minZoom = newZoom;

        this.centerRaster();
        view.play();
    },
    centerRaster: function () {
        var previousBounds = this.bg.bounds;
        var boundCenter = this.paper.view.bounds.getCenter();
        boundCenter.y -= 50;
        this.bg.bounds.setCenter(boundCenter);
        var newBounds = this.bg.bounds;
        // calculate the repositioning x and y values to move the paths
        _.each(this.drawnPaths, function (path) {
            path.translate(new paper.Point(newBounds.x - previousBounds.x, newBounds.y - previousBounds.y));
        });
        this.paper.view.play();
    },
    addToHistory: function (segment, pathID, c) {
        if (this.historyPaths.length > 30) {
            this.historyPaths.shift();
        }
        // split if too long path
        var lastEntry = _.last(this.historyPaths);
        if (lastEntry.length > 20) {
            this.historyPaths.push([]);
        }
        _.last(this.historyPaths).push({
            pathID: pathID,
            segment: segment,
            circle: c
        });
        // remove old lastUndo because we did something new
        this.lastUndos = [];
        $('.redo').addClass('inactive');
        $('.undo').removeClass('inactive');
    },
    plusZoom: function () {
        this.mouseWheel({
            deltaY: -1
        });
    },
    minusZoom: function () {
        this.mouseWheel({
            deltaY: 1
        });
    },
    mouseWheel: function (event) {
        var that = this;
        var start = 2.5,
            reduce = 20;

        if (that.paper.view.zoom == 1) {
            start = 3;
            reduce = 1;
        }

        if (that.minZoom === undefined) {
            that.minZoom = 1;
        }
        var newZoom = that.paper.view.zoom + Math.pow(start, (event.deltaY / reduce));
        if (event.deltaY > 0) {
            newZoom = that.paper.view.zoom - Math.pow(start, -(event.deltaY / reduce));
        }

        if (newZoom <= that.minZoom) {
            newZoom = that.minZoom;
        }
        that.paper.view.zoom = newZoom;
        that.paper.view.play();
    },
    startPathAnimation: function () {
        _.each(this.drawnPaths, function (path) {
            path.onFrame = function (e) {
                if (e.count % 30 == 0) {
                    if (this.opacity == 0) {
                        this.set({
                            opacity: 1
                        });
                    } else {
                        this.set({
                            opacity: 0
                        });
                    }
                }
            };
        });
    },
    // TODO evtl toggle ??
    startCorrection: function () {
        var that = this;
        if (!_.isUndefined(this.uebungMode) && !_.isUndefined(this.selectedLeitbahn)) {
            this.setBackgroundImage(this.selectedLeitbahn + "_" + this.uebungMode);
            this.startPathAnimation();
            this.paper.view.play();
        } else {
            // selectedLeitbahn = undefined ->> Vorderpfote / Hinterpfote
            this.setBackgroundImage(this.uebungMode);
            this.startPathAnimation();
            this.paper.view.play();
        }
    },
    setBackgroundImage: function (img_name) {
        var that = this;
        $(this.bg.image).attr("src", "img/" + img_name + ".jpg");
        this.paper.view.draw();
    },
    setStartNewPath: function () {
        this.startNewPath = true;
    },
    setPaint: function (e) {
        this.isPainting = !this.isPainting;
        $('.paint', this.$el).toggleClass('active');
        $("body").toggleClass("painting");

        if (!this.isPainting) {
            this.dragTool.activate();
        } else {
            if (this.uebungMode == "leitbahn") {
                this.pathTool.activate();
            }
        }
    },
    undo: function () {
        var lastHistory = this.historyPaths.pop();
        if (this.historyPaths.length === 0) {
            $(".undo").addClass("inactive");
        }
        if (!_.isUndefined(lastHistory)) {
            this.lastUndos.push(lastHistory);
            $(".redo").removeClass("inactive");
            var path = _.where(this.drawnPaths, {
                'id': lastHistory[0].pathID
            })[0];
            if (lastHistory[0].circle) {
                path.removeSegments(0, path.segments.length);
                path.data.text.set({
                    visible: false
                });
                $(".wichtige_punkte").append('<li><span class="triangle color_' + this.selectedLeitbahn.toLowerCase() + ' ui-draggable" data-leitbahn-name="' + path.data.text.content + '" data-color-name="' + this.selectedLeitbahn + '"></span> ' + path.data.text.content + '</li>');
                this.setDraggable();
            } else {
                path.removeSegments(path.segments.length - lastHistory.length, path.segments.length);
                this.currentPath = path;
            }

            this.paper.view.play();
        }
    },
    redo: function () {
        var lastUndo = this.lastUndos.pop();
        if (this.lastUndos.length === 0) {
            $(".redo").addClass("inactive");
        }
        if (!_.isUndefined(lastUndo)) {
            this.historyPaths.push(lastUndo);
            $(".undo").removeClass('inactive');
            var path = _.where(this.drawnPaths, {
                'id': lastUndo[0].pathID
            })[0];
            if (lastUndo[0].circle) {
                _.each(lastUndo, function (undo) {
                    _.each(undo.segment, function (s) {
                        path.addSegment(s);
                    });
                    path.data.text.set({
                        visible: true
                    });
                    $(".wichtige_punkte").find("[data-leitbahn-name='" + path.data.text.content + "']").parent().remove();
                });
            } else {
                _.each(lastUndo, function (undo) {
                    path.addSegment(undo.segment);
                });
                this.currentPath = path;
            }
            this.paper.view.play();
        }
    }
});